# Supplier Products AI Rewrite

AI-powered content enhancement for supplier products in Drupal 11.

## Features

- **Automatic AI Content Generation**: Automatically rewrites product titles, descriptions, extracts attributes, and suggests categories using AI
- **Smart Change Detection**: Uses MD5 signatures to detect when source content changes
- **Hybrid Caching**: File-based cache to minimize AI API calls
- **Batch Processing**: Configurable batch size for efficient API usage
- **Supplier-Level Configuration**: Per-supplier AI rules and toggles
- **Asynchronous Processing**: Queue-based processing via cron
- **Admin Tools**: VBO actions and batch processing interface
- **Debug Mode**: Mock responses and detailed logging for testing

## Requirements

- Drupal 10 or 11
- [AI module](https://www.drupal.org/project/ai) with configured AI provider
- Content type: `supplier_product` with required fields:
  - `field_original_product_title`
  - `field_supplier_product_descripti`
  - `field_supplier` (entity reference to `suppliers` taxonomy)


## Dependencies

* `atillaphp/supplier_products`
* `drupal/token`
* `atillaphp/key_value_ifta_widget`

## Installation

1. Install the module: `composer require drupal/ai`
2. Enable the module: `drush en supplier_products_ai_rewrite -y`
3. Configure your AI provider at `/admin/config/ai`
4. Configure AI settings at `/admin/commerce/config/synchronization/ai-settings`

## Configuration

### Global Settings

Configure at `/admin/commerce/config/synchronization/ai-settings`:

- **AI Role Description**: Define the AI persona
- **Task Description**: General task objective for the AI
- **Context Instructions**: Additional context for content generation
- **Supplier Data Template**: Token-based template for product data
- **Site Data Template**: Token-based template for site categories/brands

### Per-Task Settings

Each task (title, description, attributes, categories, brand) can be:

- Enabled/disabled globally
- Configured with custom prompts
- Mapped to specific target fields

### Supplier Configuration

On each supplier taxonomy term, configure:

- **AI Title Instructions**: Supplier-specific title rules
- **AI Description Instructions**: Supplier-specific description rules

### Commerce Integration

The module integrates with commerce product creation:

| Setting              | Purpose                                                              | Default    |
| -------------------- | -------------------------------------------------------------------- | ---------- |
| `enhance_on_create`  | Trigger AI enhancement when creating commerce products               | `true`     |
| `enhance_on_merge`   | Trigger AI enhancement when merging products from multiple suppliers | `true`     |
| `merge_instructions` | Special instructions for handling merged products                    | See config |

When `enhance_on_merge` is enabled and products from different suppliers are merged, the AI receives special instructions to harmonize the content from all sources.

### Field Mapping

The module creates these fields on `supplier_product` nodes:

| Field                           | Purpose                            | Type             |
| ------------------------------- | ---------------------------------- | ---------------- |
| `field_ai_title`                | AI-generated title                 | String           |
| `field_ai_description`          | AI-generated description           | Text (formatted) |
| `field_ai_attributes`           | AI-extracted attributes            | Key-Value pairs  |
| `field_ai_suggested_categories` | AI-suggested categories            | Entity reference |
| `field_ai_suggested_brand`      | AI-suggested brand                 | Entity reference |
| `field_title_signature`         | MD5 signature for change detection | String           |
| `field_description_signature`   | MD5 signature for change detection | String           |

## Usage

### Automatic Processing (Recommended)

1. Edit a supplier product
2. Update `field_original_product_title` or `field_supplier_product_descripti`
3. Save the node
4. AI processing queues automatically
5. Run cron: `drush cron`

### Views Bulk Operations

1. Go to the Supplier Product Management view
2. Select products to enhance
3. Choose "AI Enhance Content" action
4. Select which tasks to run
5. Execute

### Single Node Enhancement

Visit `/node/{nid}/ai-enhance` to trigger AI enhancement for a specific product.

### Cache Management

Manage AI response cache at `/admin/commerce/config/synchronization/ai-cache`:

- View cache statistics
- Clear outdated cache entries
- Regenerate cache for specific items

## Architecture

### Services

| Service                                         | Purpose                                  |
| ----------------------------------------------- | ---------------------------------------- |
| `supplier_products_ai_rewrite.prompt_builder`   | Builds system/user prompts for AI        |
| `supplier_products_ai_rewrite.cache_manager`    | Manages file-based response caching      |
| `supplier_products_ai_rewrite.result_processor` | Parses AI responses and applies to nodes |

### Change Detection (hook_node_presave)

- Calculates MD5 signatures of original content
- Compares with stored signatures
- Dispatches jobs to queue if changes detected

### Queue Worker (AIContentEnhancer)

1. Loads node and validates supplier settings
2. Checks file cache for existing results
3. Builds prompts using PromptBuilder service
4. Calls AI provider using `drupal/ai` module
5. Parses results using ResultProcessor service
6. Saves results to cache and node

### Batch Processing

When `batch_size` > 1:

- Multiple products are batched into a single AI call
- Each product is identified by `nid` in the response
- Reduces API calls and improves throughput
- Falls back to individual processing on errors

### Caching Strategy

- **Cache Key**: Combination of context hash + prompt hash + input data hash
- **Storage**: File-based in `public://aicache/` or `private://aicache/`
- **Invalidation**: Automatic when prompts or input data change

## Troubleshooting

### Queue Not Processing

```bash
# Check queue status
drush queue:list

# Run queue manually
drush queue:run ai_content_enhancer

# Check logs
drush watchdog:show supplier_products_ai_rewrite
```

### Content Not Updating

1. Check AI provider configuration at `/admin/config/ai`
2. Verify task is enabled in settings
3. Check if input content exists (title/description)
4. Enable debug mode to see prompts and responses

### Debug Mode

Enable at `/admin/commerce/config/synchronization/ai-settings`:

- **Log Prompts**: See what's being sent to AI
- **Log Responses**: See what AI returns
- **Use Mock**: Test without consuming API tokens

## Views Integration

The module provides:

- **AI Enhancement Status Field**: Shows which AI fields are populated
- **AI Enhancement Status Filter**: Filter by enhancement status (enhanced/not enhanced)

## Maintainers

Current maintainers:

- Project team

This module was created for Soğan Commerce.
