<?php

/**
 * @file
 * Views integration for supplier_products module.
 */

/**
 * Implements hook_views_data_alter().
 */
function supplier_products_views_data_alter(array &$data)
{
    $data['feeds_feed']['processor_mode'] = [
        'title' => t('Processor Mode'),
        'help' => t('Displays "Create" or "Update" based on the feed type processor settings.'),
        'field' => [
            'id' => 'feed_processor_mode',
        ],
    ];

    $data['feeds_feed']['feed_import_period'] = [
        'title' => t('Feed Import Period'),
        'help' => t('Displays the import period from the feed type in human-readable format.'),
        'field' => [
            'id' => 'feed_import_period',
        ],
    ];

    $data['feeds_feed']['feed_progress'] = [
        'title' => t('Feed Progress'),
        'help' => t('Displays a visual progress bar showing the import progress of the feed.'),
        'field' => [
            'id' => 'feed_progress',
        ],
    ];

    $data['feeds_feed']['feed_import_times'] = [
        'title' => t('Feed Import Times'),
        'help' => t('Displays combined last import and next import times with auto-refresh support.'),
        'field' => [
            'id' => 'feed_import_times',
        ],
    ];

    $data['feeds_feed']['feed_items_imported'] = [
        'title' => t('Feed Items Imported'),
        'help' => t('Displays the number of items imported with auto-refresh support.'),
        'field' => [
            'id' => 'feed_items_imported',
        ],
    ];
}
