<?php

namespace Drupal\supplier_products\Plugin\QueueWorker;

use Drupal\Core\Queue\QueueWorkerBase;

/**
 * Processes supplier product variation synchronization items.
 *
 * @QueueWorker(
 *   id = "supplier_products_variation_sync",
 *   title = @Translation("Supplier product variation synchronizer"),
 *   cron = {"time" = 30}
 * )
 */
class VariationSyncQueueWorker extends QueueWorkerBase
{

    /**
     * {@inheritdoc}
     */
    public function processItem($data): void
    {
        if (empty($data['supplier_id']) || empty($data['parent_sku'])) {
            return;
        }

        \_supplier_products_sync_variation_group((int) $data['supplier_id'], (string) $data['parent_sku']);
    }
}
