<?php

namespace Drupal\stockmount_xml\Plugin\views\field;

use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;

/**
 * Field handler to display formatted VaryantGrupKodu from product ID.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("stockmount_varyant_grup_kodu")
 */
class VaryantGrupKodu extends FieldPluginBase
{

    /**
     * {@inheritdoc}
     */
    public function query()
    {
        // This field doesn't need a query.
    }

    /**
     * {@inheritdoc}
     */
    public function render(ResultRow $values)
    {
        $entity = $values->_entity;

        if (!$entity || !method_exists($entity, 'getProduct')) {
            return '';
        }

        $product = $entity->getProduct();
        if (!$product) {
            return '';
        }

        // Format: VG-000001
        return 'VG-' . str_pad($product->id(), 6, '0', STR_PAD_LEFT);
    }
}
