<?php

namespace Drupal\stockmount_xml\Plugin\views\field;

use Drupal\Core\Extension\ModuleHandlerInterface;
use Drupal\views\Plugin\views\field\FieldPluginBase;
use Drupal\views\ResultRow;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Field handler to display stock quantity from commerce_stock.
 *
 * @ingroup views_field_handlers
 *
 * @ViewsField("stockmount_stok_adedi")
 */
class StokAdedi extends FieldPluginBase
{

    /**
     * The module handler.
     *
     * @var \Drupal\Core\Extension\ModuleHandlerInterface
     */
    protected $moduleHandler;

    /**
     * The stock service manager.
     *
     * @var object|null
     */
    protected $stockServiceManager;

    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition)
    {
        $instance = parent::create($container, $configuration, $plugin_id, $plugin_definition);
        $instance->moduleHandler = $container->get('module_handler');
        if ($container->has('commerce_stock.service_manager')) {
            $instance->stockServiceManager = $container->get('commerce_stock.service_manager');
        }
        return $instance;
    }

    /**
     * {@inheritdoc}
     */
    public function query()
    {
        // This field doesn't need a query.
    }

    /**
     * {@inheritdoc}
     */
    public function render(ResultRow $values)
    {
        $entity = $values->_entity;

        if (!$entity) {
            return '0';
        }

        // Check if commerce_stock module exists.
        if (!$this->moduleHandler->moduleExists('commerce_stock') || !$this->stockServiceManager) {
            return '0';
        }

        try {
            $stock = (int) $this->stockServiceManager->getStockLevel($entity);
            return (string) $stock;
        } catch (\Exception $e) {
            return '0';
        }
    }
}
