<?php

namespace Drupal\stockmount_xml\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Event subscriber to display XML inline in browser instead of downloading.
 */
class XmlInlineBrowserSubscriber implements EventSubscriberInterface
{

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        // Run after views_data_export sets headers.
        return [
            KernelEvents::RESPONSE => ['onResponse', -100],
        ];
    }

    /**
     * Modify response to display XML inline in browser.
     */
    public function onResponse(ResponseEvent $event)
    {
        $request = $event->getRequest();
        $response = $event->getResponse();

        // Only modify for our XML export path.
        if ($request->getPathInfo() !== '/xml/stockmount.xml') {
            return;
        }

        $contentType = $response->headers->get('Content-Type');
        if ($contentType && str_contains($contentType, 'xml')) {
            // Change from attachment to inline so browser displays it.
            $response->headers->set('Content-Disposition', 'inline');
        }
    }
}
