<?php

namespace Drupal\stockmount_xml\EventSubscriber;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\Event\ResponseEvent;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Event subscriber to wrap specific fields in CDATA tags.
 */
class XmlCdataSubscriber implements EventSubscriberInterface
{

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        return [
            KernelEvents::RESPONSE => ['onResponse', 0],
        ];
    }

    /**
     * Replaces CDATA placeholder markers with actual CDATA tags.
     *
     * @param \Symfony\Component\HttpKernel\Event\ResponseEvent $event
     *   The response event.
     */
    public function onResponse(ResponseEvent $event)
    {
        $response = $event->getResponse();
        $contentType = $response->headers->get('Content-Type');

        // Only process XML responses.
        if ($contentType === NULL || strpos($contentType, 'xml') === FALSE) {
            return;
        }

        $content = $response->getContent();
        if (!is_string($content) || empty($content)) {
            return;
        }

        // Replace CDATA placeholder markers with actual CDATA tags.
        $content = str_replace('___CDATA_START___', '<![CDATA[', $content);
        $content = str_replace('___CDATA_END___', ']]>', $content);

        $response->setContent($content);
    }
}
