<?php

namespace Drupal\Tests\sogan_commerce_product\Kernel\Service;

use Drupal\KernelTests\KernelTestBase;
use Drupal\commerce_product\Entity\Product;
use Drupal\commerce_product\Entity\ProductVariation;
use Drupal\sogan_commerce_product\Service\VariationBuilder;
use Drupal\taxonomy\Entity\Term;
use Drupal\taxonomy\Entity\Vocabulary;

/**
 * Kernel tests for VariationBuilder service.
 *
 * @group sogan_commerce_product
 * @coversDefaultClass \Drupal\sogan_commerce_product\Service\VariationBuilder
 */
class VariationBuilderTest extends KernelTestBase
{

    /**
     * Modules to enable.
     *
     * @var array
     */
    protected static $modules = [
        'system',
        'user',
        'field',
        'text',
        'filter',
        'path',
        'entity',
        'token',
        'file',
        'image',
        'media',
        'media_library',
        'views',
        'entity_test',
        'commerce',
        'commerce_price',
        'commerce_store',
        'commerce_product',
        'taxonomy',
        'options',
        'address',
        'datetime',
        'inline_entity_form',
        'sogan_commerce_product', // Our module
        // Dependencies of our module (assumed)
        'commerce_stock',
        'address_tr',
    ];

    /**
     * @var \Drupal\sogan_commerce_product\Service\VariationBuilder
     */
    protected $variationBuilder;

    /**
     * {@inheritdoc}
     */
    protected function setUp(): void
    {
        parent::setUp();
        $this->installEntitySchema('user');
        $this->installEntitySchema('file'); // Important for file module
        $this->installEntitySchema('commerce_product');
        $this->installEntitySchema('commerce_product_variation');
        $this->installEntitySchema('taxonomy_term');
        $this->installEntitySchema('commerce_store');
        $this->installConfig(['system', 'file', 'image', 'commerce_product', 'sogan_commerce_product']);

        // Set up required vocabularies
        Vocabulary::create(['vid' => 'suppliers', 'name' => 'Suppliers'])->save();
        Vocabulary::create(['vid' => 'brands', 'name' => 'Brands'])->save();

        // Get the service
        $this->variationBuilder = $this->container->get('sogan_commerce_product.variation_builder');
    }

    /**
     * Tests creating a variation from a group of nodes.
     */
    public function testCreateVariationFromGroup()
    {
        $this->assertInstanceOf(VariationBuilder::class, $this->variationBuilder);
        $this->assertTrue(TRUE);
    }
}
