<?php

namespace Drupal\sogan_commerce_product\EventSubscriber;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\commerce_product\Event\ProductVariationEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Clears supplier node references when a product variation is deleted.
 */
class VariationDeleteSubscriber implements EventSubscriberInterface
{
    /**
     * The entity type manager.
     *
     * @var \Drupal\Core\Entity\EntityTypeManagerInterface
     */
    protected $entityTypeManager;

    /**
     * Constructs a new VariationDeleteSubscriber object.
     */
    public function __construct(EntityTypeManagerInterface $entity_type_manager)
    {
        $this->entityTypeManager = $entity_type_manager;
    }

    /**
     * {@inheritdoc}
     */
    public static function getSubscribedEvents()
    {
        // Subscribe to variation predelete event
        $events = [];
        
        // Using entity type hooks since Commerce Product may not have specific events
        // We'll use hook_entity_predelete instead via services
        return $events;
    }

    /**
     * Clears field_associated_product_variati on supplier nodes when variation is deleted.
     *
     * @param \Drupal\commerce_product\Entity\ProductVariationInterface $variation
     *   The variation being deleted.
     */
    public function clearSupplierReferences($variation)
    {
        // Get supplier nodes that reference this variation
        if (!$variation->hasField('field_source_supplier_products') || $variation->get('field_source_supplier_products')->isEmpty()) {
            return;
        }

        $supplier_node_ids = [];
        foreach ($variation->get('field_source_supplier_products') as $item) {
            if ($item->target_id) {
                $supplier_node_ids[] = $item->target_id;
            }
        }

        if (empty($supplier_node_ids)) {
            return;
        }

        // Load supplier nodes and clear their field_associated_product_variati field
        $node_storage = $this->entityTypeManager->getStorage('node');
        $supplier_nodes = $node_storage->loadMultiple($supplier_node_ids);

        foreach ($supplier_nodes as $node) {
            if ($node->hasField('field_associated_product_variati') && !$node->get('field_associated_product_variati')->isEmpty()) {
                // Only clear if it references THIS variation
                $current_variation_id = $node->get('field_associated_product_variati')->target_id;
                if ($current_variation_id == $variation->id()) {
                    $node->set('field_associated_product_variati', NULL);
                    $node->save();
                }
            }
        }
    }
}
