<?php

namespace Drupal\sogan_commerce_product\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;

class ProductsConfigController extends ControllerBase
{
    /**
     * Products configuration landing page.
     */
    public function index()
    {
        $blocks = [];

        // Add Synchronization block
        $blocks[] = [
            'title' => $this->t('Synchronization'),
            'description' => $this->t('Settings for product synchronization and imports'),
            'url' => Url::fromRoute('sogan_commerce_product.synchronization'),
        ];

        return [
            '#theme' => 'admin_block_content',
            '#content' => $blocks,
        ];
    }

    /**
     * Synchronization settings landing page.
     */
    public function synchronization()
    {
        $blocks = [];

        // Add SKU Settings block
        $blocks[] = [
            'title' => $this->t('SKU Settings'),
            'description' => $this->t('SKU generation and field visibility settings'),
            'url' => Url::fromRoute('sogan_commerce_product.sku_settings'),
        ];

        // Add Image Settings block
        $blocks[] = [
            'title' => $this->t('Image Settings'),
            'description' => $this->t('Remote image download and processing settings'),
            'url' => Url::fromRoute('sogan_commerce_product.image_settings'),
        ];

        // Add Merge Settings block
        $blocks[] = [
            'title' => $this->t('Merge Settings'),
            'description' => $this->t('Configure merge policies for product creation from multiple suppliers'),
            'url' => Url::fromRoute('sogan_commerce_product.merge_settings'),
        ];

        // Add Product Merger Export/Import block
        if (\Drupal::service('module_handler')->moduleExists('sogan_product_merger')) {
            $blocks[] = [
                'title' => $this->t('Export & Import Merge Relationships'),
                'description' => $this->t('Export and import product equivalence maps.'),
                'url' => Url::fromRoute('sogan_product_merger.ui'),
            ];
        }

        // Add AI Content Rewrite Settings block
        if (\Drupal::service('module_handler')->moduleExists('supplier_products_ai_rewrite')) {
            $blocks[] = [
                'title' => $this->t('AI Content Rewrite Settings'),
                'description' => $this->t('Configure AI content rewrite prompt templates'),
                'url' => Url::fromRoute('supplier_products_ai_rewrite.settings'),
            ];
            $blocks[] = [
                'title' => $this->t('AI Cache Management'),
                'description' => $this->t('Import, export, and manage AI cache files'),
                'url' => Url::fromRoute('supplier_products_ai_rewrite.cache_management'),
            ];
        }

        // Add Feeds Performance block
        if (\Drupal::service('module_handler')->moduleExists('feeds_performance')) {
            $blocks[] = [
                'title' => $this->t('Feeds Performance'),
                'description' => $this->t('Configure performance settings for feed imports'),
                'url' => Url::fromRoute('feeds_performance.synchronization_settings'),
            ];
        }

        return [
            '#theme' => 'admin_block_content',
            '#content' => $blocks,
        ];
    }
}
