<?php

/**
 * @file
 * Hooks provided by the Sogan Commerce Product module.
 */

/**
 * @addtogroup hooks
 * @{
 */

/**
 * Alter the available text field merge strategies.
 *
 * This hook allows modules to add custom text selection strategies for
 * merging product names and descriptions from multiple supplier products.
 *
 * @param array &$strategies
 *   An associative array of strategy options, keyed by machine name with
 *   translated labels as values.
 *
 * @see \Drupal\sogan_commerce_product\Form\MergeSettingsForm::buildForm()
 *
 * Example:
 * @code
 * function mymodule_sogan_commerce_text_strategies_alter(&$strategies) {
 *   $strategies['custom_concat'] = t('Concatenate - Combine all values');
 *   $strategies['first_word'] = t('First Word - Use first word only');
 * }
 * @endcode
 */
function hook_sogan_commerce_text_strategies_alter(array &$strategies) {
  // Add your custom text merge strategies here.
  $strategies['my_custom_strategy'] = t('My Custom Strategy - Description');
}

/**
 * Alter the available price field merge strategies.
 *
 * This hook allows modules to add custom price calculation strategies for
 * merging cost prices, list prices, and suggested prices from multiple
 * supplier products.
 *
 * @param array &$strategies
 *   An associative array of strategy options, keyed by machine name with
 *   translated labels as values.
 *
 * @see \Drupal\sogan_commerce_product\Form\MergeSettingsForm::buildForm()
 *
 * Example:
 * @code
 * function mymodule_sogan_commerce_price_strategies_alter(&$strategies) {
 *   $strategies['median'] = t('Median - Use median price');
 *   $strategies['mode'] = t('Mode - Use most common price');
 * }
 * @endcode
 */
function hook_sogan_commerce_price_strategies_alter(array &$strategies) {
  // Add your custom price calculation strategies here.
  $strategies['my_custom_price_strategy'] = t('My Custom Price Strategy - Description');
}

/**
 * @} End of "addtogroup hooks".
 */
