/**
 * Implements hook_schema().
 */
function sogan_commerce_product_schema() {
  $schema['sogan_commerce_image_queue'] = [
    'description' => 'Queue for retrying failed product image downloads',
    'fields' => [
      'id' => [
        'type' => 'serial',
        'not null' => TRUE,
        'description' => 'Primary key',
      ],
      'product_id' => [
        'type' => 'int',
        'unsigned' => TRUE,
        'not null' => TRUE,
        'description' => 'Product ID',
      ],
      'image_urls' => [
        'type' => 'text',
        'not null' => TRUE,
        'description' => 'JSON array of image URLs to retry',
      ],
      'attempts' => [
        'type' => 'int',
        'unsigned' => TRUE,
        'not null' => TRUE,
        'default' => 0,
        'description' => 'Number of retry attempts',
      ],
      'created' => [
        'type' => 'int',
        'unsigned' => TRUE,
        'not null' => TRUE,
        'description' => 'Unix timestamp when queued',
      ],
      'last_attempt' => [
        'type' => 'int',
        'unsigned' => TRUE,
        'not null' => TRUE,
        'default' => 0,
        'description' => 'Unix timestamp of last retry attempt',
      ],
      'status' => [
        'type' => 'varchar',
        'length' => 20,
        'not null' => TRUE,
        'default' => 'pending',
        'description' => 'Status: pending, processing, completed, failed',
      ],
      'context' => [
        'type' => 'varchar',
        'length' => 20,
        'not null' => TRUE,
        'default' => 'creation',
        'description' => 'Context: creation or manual',
      ],
    ],
    'primary key' => ['id'],
    'indexes' => [
      'status' => ['status'],
      'product_id' => ['product_id'],
      'created' => ['created'],
    ],
  ];

  $schema['sogan_commerce_sku_sequence'] = [
    'description' => 'SKU sequence numbers per prefix',
    'fields' => [
      'prefix' => [
        'type' => 'varchar',
        'length' => 50,
        'not null' => TRUE,
        'description' => 'SKU prefix',
      ],
      'last' => [
        'type' => 'int',
        'unsigned' => TRUE,
        'not null' => TRUE,
        'default' => 0,
        'description' => 'Last generated sequence number',
      ],
    ],
    'primary key' => ['prefix'],
  ];

  return $schema;
}

/**
 * Create image queue table and enforce local_stock service.
 */
function sogan_commerce_product_update_9302() {
  // Create image queue table
  $schema = sogan_commerce_product_schema();
  $spec = $schema['sogan_commerce_image_queue'];
  \Drupal::database()->schema()->createTable('sogan_commerce_image_queue', $spec);

  // Ensure SKU sequence table exists
  if (!\ Drupal::database()->schema()->tableExists('sogan_commerce_sku_sequence')) {
    $spec = $schema['sogan_commerce_sku_sequence'];
    \Drupal::database()->schema()->createTable('sogan_commerce_sku_sequence', $spec);
  }

  // Force all variations to use local_stock service
  $config = \Drupal::configFactory()->getEditable('commerce_stock.service_manager');
  $config->set('default_service_id', 'local_stock');
  $config->set('commerce_product_variation_default_service_id', 'local_stock');
  $config->save();

  // Clear all caches
  drupal_flush_all_caches();

  return t('Created image queue table, enforced local_stock service, and cleared caches.');
}
