/**
 * @file
 * Supplier products table lightbox functionality.
 */

(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.supplierTableLightbox = {
    attach: function (context, settings) {
      const triggers = once('supplier-lightbox', '.supplier-table-lightbox-trigger', context);
      
      triggers.forEach(function (trigger) {
        $(trigger).on('click', function (e) {
          e.preventDefault();
          
          var $button = $(this);
          var tableId = $button.data('table-id');
          var $tableContent = $('#' + tableId);
          
          if ($tableContent.length) {
            // Clone the table content
            var $clonedContent = $tableContent.clone();
            $clonedContent.find('table').show();
            $clonedContent.css('display', 'block');
            
            // Create dialog
            var dialog = Drupal.dialog($clonedContent.html(), {
              title: Drupal.t('Supplier Products'),
              width: 'auto',
              maxWidth: '90%',
              dialogClass: 'supplier-products-lightbox-dialog',
              buttons: [
                {
                  text: Drupal.t('Close'),
                  class: 'button button--primary',
                  click: function () {
                    $(this).dialog('close');
                  }
                }
              ]
            });
            
            dialog.showModal();
          }
        });
      });
    }
  };

})(jQuery, Drupal, once);
