<?php

namespace Drupal\commerce_turkey_vat\Plugin\Commerce\TaxType;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\commerce_tax\Attribute\CommerceTaxType;
use Drupal\commerce_tax\TaxZone;
use Drupal\commerce_tax\Plugin\Commerce\TaxType\LocalTaxTypeBase;

/**
 * Provides the Turkey VAT tax type.
 */
#[CommerceTaxType(
    id: "turkey_vat",
    label: new TranslatableMarkup("Turkey VAT"),
)]
class TurkeyVat extends LocalTaxTypeBase
{

    /**
     * {@inheritdoc}
     */
    public function buildConfigurationForm(array $form, FormStateInterface $form_state)
    {
        $form = parent::buildConfigurationForm($form, $form_state);
        $form['rates'] = $this->buildRateSummary();
        // Replace the phrase "tax rates" with "VAT rates" to be more precise.
        $form['rates']['#markup'] = $this->t('The following VAT rates are provided:');

        return $form;
    }

    /**
     * {@inheritdoc}
     */
    public function buildZones()
    {
        $zones['tr'] = new TaxZone([
            'id' => 'tr',
            'label' => $this->t('Turkey'),
            'display_label' => $this->t('KDV'),
            'territories' => [
                ['country_code' => 'TR'],
            ],
            'rates' => [
                [
                    'id' => 'standard',
                    'label' => $this->t('Standard (20%)'),
                    'percentages' => [
                        ['number' => '0.20', 'start_date' => '2023-07-01'],
                    ],
                    'default' => TRUE,
                ],
                [
                    'id' => 'reduced_high',
                    'label' => $this->t('Reduced (10%)'),
                    'percentages' => [
                        ['number' => '0.10', 'start_date' => '2023-07-01'],
                    ],
                ],
                [
                    'id' => 'reduced_low',
                    'label' => $this->t('Reduced (1%)'),
                    'percentages' => [
                        ['number' => '0.01', 'start_date' => '2023-07-01'],
                    ],
                ],
            ],
        ]);

        return $zones;
    }
}
