# Commerce Paratika Payment Gateway

A Drupal Commerce payment gateway module for Paratika, a Turkish payment service provider.

## Features

- ✅ **Credit Card Form on Checkout Page** - Card details are entered directly on your checkout page
- ✅ **3D Secure Authentication** - 3DS authentication is displayed in a lightbox/modal overlay
- ✅ **Installment Payments** - Supports Turkish bank installment plans with dynamic loading based on card BIN
- ✅ **Test/Production Modes** - Easy switching between test and production environments
- ✅ **PCI DSS Compliant** - Uses Paratika's Direct POST method, card data never touches your server
- ✅ **Refund Support** - Process refunds directly from the Drupal admin panel


## Dependencies

* `drupal/commerce`

## Installation

1. Enable the module:
   ```bash
   ddev drush en commerce_paratika -y
   ```

2. Clear cache:
   ```bash
   ddev drush cr
   ```

## Configuration

1. Navigate to **Commerce → Configuration → Payment gateways** (`/admin/commerce/config/payment-gateways`)

2. Click **Add payment gateway**

3. Select **Paratika** from the plugin dropdown

4. Configure the gateway:
   - **Label**: Give your gateway a name (e.g., "Credit Card")
   - **Merchant ID**: Your Paratika merchant ID
   - **Merchant User**: Your Paratika merchant user
   - **Merchant Password**: Your Paratika merchant password
   - **Test mode**: Check this box to use the test environment

5. Save the configuration

## Testing

### Test Environment

When test mode is enabled, the module uses Paratika's test API:
- **Test API URL**: `https://test.paratika.com.tr/paratika/api/v2`

### Test Cards

Use these test cards provided by Paratika:

| Card Number         | Expiry | CVV | Result  |
|---------------------|--------|-----|---------|
| 4111111111111111    | 12/25  | 123 | Success |
| 5456165456165454    | 12/25  | 123 | Success |

### Testing Flow

1. Add a product to cart
2. Proceed to checkout
3. Enter test card details on the checkout page
4. Select installment option (if available)
5. Click "Pay"
6. Complete 3DS authentication in the lightbox
7. Verify order completes successfully

## How It Works

### Payment Flow

1. **Checkout Page**: Customer enters credit card details directly on your checkout page
2. **Session Token**: Module creates a session token with Paratika API
3. **Installment Query**: As customer types card number, available installments are loaded via AJAX
4. **Payment Submission**: Card data is posted directly to Paratika (never touches your server)
5. **3DS Authentication**: Paratika redirects to bank's 3DS page, displayed in a lightbox
6. **Callback**: After 3DS completion, customer returns to your site
7. **Verification**: Module verifies the transaction with Paratika API
8. **Completion**: Order is marked as paid and customer sees confirmation

### Security

- Card data is posted directly to Paratika using their Direct POST 3D Secure method
- Your server never stores or processes sensitive card information
- All communication with Paratika uses HTTPS/TLS encryption
- Maintains PCI DSS compliance

## API Integration

The module integrates with these Paratika API endpoints:

- **PAYMENTSESSION** - Create payment session token
- **QUERYINSTALLMENT** - Query available installments for a card BIN
- **QUERYTRANSACTION** - Verify transaction status
- **REFUND** - Process refunds
- **CANCEL** - Void/cancel transactions

## Troubleshooting

### Payment fails with "Missing Paratika transaction ID"

This usually means the 3DS authentication didn't complete successfully. Check:
- Your return URL is accessible
- The order ID is being passed correctly
- Paratika credentials are correct

### Installments not loading

Check:
- JavaScript console for errors
- Network tab to see if AJAX request is being made
- Merchant credentials are correct

### 3DS lightbox doesn't appear

Check:
- JavaScript library is loaded (`commerce_paratika/paratika_payment`)
- No JavaScript errors in console
- CSS file is loaded

## Support

For issues with:
- **Module functionality**: Check Drupal logs at `/admin/reports/dblog`
- **Paratika API**: Contact Paratika support at destek@paratika.com.tr or 02123190625
- **Payment gateway configuration**: Review the implementation plan

## License

GPL-2.0-or-later
