<?php

namespace Drupal\commerce_courier_shipping\Service;

/**
 * Interface for the location matcher service.
 */
interface LocationMatcherServiceInterface
{

    /**
     * Checks if an address matches any of the enabled locations.
     *
     * @param array $enabled_locations
     *   Array of enabled location configurations.
     * @param string $province_code
     *   The province code.
     * @param string $district_code
     *   The district code.
     * @param string $neighbourhood_code
     *   The neighbourhood code.
     *
     * @return bool
     *   TRUE if the location is enabled, FALSE otherwise.
     */
    public function isLocationEnabled(array $enabled_locations, string $province_code, string $district_code, string $neighbourhood_code = ''): bool;
}
