<?php

namespace Drupal\commerce_courier_shipping\Service;

/**
 * Interface for the distance calculator service.
 */
interface DistanceCalculatorInterface
{

    /**
     * Calculates the distance between store and destination addresses.
     *
     * @param string $store_address
     *   The formatted store address string.
     * @param string $destination_address
     *   The formatted destination address string.
     *
     * @return int|null
     *   The distance in kilometers (ceiled), or NULL on error.
     */
    public function calculateDistance(string $store_address, string $destination_address): ?int;

    /**
     * Formats an address array into a string for API calls.
     *
     * @param array $address
     *   The address array with keys like address_line1, locality, etc.
     *
     * @return string
     *   The formatted address string.
     */
    public function formatAddress(array $address): string;
}
