<?php

namespace Drupal\bdm_xml_feed_import\Feeds\Fetcher;

use Drupal\feeds\Feeds\Fetcher\HttpFetcher;
use GuzzleHttp\RequestOptions;

/**
 * Defines an HTTP fetcher with browser User-Agent for BDM XML feeds.
 *
 * @FeedsFetcher(
 *   id = "browser_http",
 *   title = @Translation("Download from URL (Browser User-Agent)"),
 *   description = @Translation("Downloads data from a URL using a browser User-Agent to bypass CDN/WAF protection."),
 *   form = {
 *     "configuration" = "Drupal\feeds\Feeds\Fetcher\Form\HttpFetcherForm",
 *     "feed" = "Drupal\feeds\Feeds\Fetcher\Form\HttpFetcherFeedForm",
 *   }
 * )
 */
class BrowserHttpFetcher extends HttpFetcher
{

    /**
     * The browser User-Agent string to use for requests.
     */
    const BROWSER_USER_AGENT = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/120.0.0.0 Safari/537.36';

    /**
     * {@inheritdoc}
     */
    protected function get($url, $sink, $cache_key = FALSE, array $options = [], array $feed_configuration = [])
    {
        // Add browser User-Agent header to bypass Cloudflare and other CDN protection.
        if (!isset($options[RequestOptions::HEADERS])) {
            $options[RequestOptions::HEADERS] = [];
        }
        $options[RequestOptions::HEADERS]['User-Agent'] = self::BROWSER_USER_AGENT;

        return parent::get($url, $sink, $cache_key, $options, $feed_configuration);
    }
}
